/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.css.core.parsing.ast;

import com.aptana.css.core.parsing.ast.CSSNode;
import com.aptana.css.core.parsing.ast.CSSTextNode;
import com.aptana.css.core.parsing.ast.CSSTreeWalker;
import com.aptana.parsing.ast.IParseNode;
import java.util.Arrays;
import java.util.List;

public class CSSMediaNode
extends CSSNode {
    private static final String MEDIA = "@media";
    private CSSTextNode[] fMedias;
    private String fText;

    public CSSMediaNode(CSSTextNode[] medias, CSSNode ... statements) {
        this.fMedias = medias;
        this.setChildren((IParseNode[])statements);
    }

    public short getNodeType() {
        return 7;
    }

    public void accept(CSSTreeWalker walker) {
        walker.visit(this);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof CSSMediaNode)) {
            return false;
        }
        CSSMediaNode other = (CSSMediaNode)((Object)obj);
        return this.toString().equals(other.toString());
    }

    public CSSTextNode[] getMedias() {
        return this.fMedias;
    }

    public CSSNode[] getStatements() {
        List<IParseNode> list = Arrays.asList(this.getChildren());
        return list.toArray(new CSSNode[list.size()]);
    }

    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append(MEDIA);
        CSSTextNode[] cSSTextNodeArray = this.fMedias;
        int n = this.fMedias.length;
        int n2 = 0;
        while (n2 < n) {
            CSSTextNode media = cSSTextNodeArray[n2];
            text.append(' ').append((Object)media);
            ++n2;
        }
        return text.toString();
    }

    public int hashCode() {
        return super.hashCode() * 31 + this.toString().hashCode();
    }

    public String toString() {
        if (this.fText == null) {
            CSSNode[] statements;
            StringBuilder text = new StringBuilder();
            text.append(MEDIA);
            CSSTextNode[] cSSTextNodeArray = this.fMedias;
            int n = this.fMedias.length;
            int n2 = 0;
            while (n2 < n) {
                CSSTextNode media = cSSTextNodeArray[n2];
                text.append(' ').append((Object)media);
                ++n2;
            }
            text.append('{');
            CSSNode[] cSSNodeArray = statements = this.getStatements();
            int n3 = statements.length;
            n = 0;
            while (n < n3) {
                CSSNode statement = cSSNodeArray[n];
                text.append((Object)statement);
                ++n;
            }
            text.append('}');
            this.fText = text.toString();
        }
        return this.fText;
    }
}

